﻿/*	VERSION:	1.2
	1.2		Added "fps" parameter
	1.1		Return the loopInterval ID so previous tweens can be cancelled
	
	DESCRIPTION:
		A simple tween system for times when Flash's native tween class is not available.

	quikTween( startAt, endAt, seconds, easeFunc, callback )

	USAGE:
		#include "functions/quikTween.as"
		quikTween( 0, 300, 1, easeOut, function( value ){
			my_mc._x = value;
		});
		
		// interrupting a tween during animation
		var animInterval = quikTween( 0, 300, 1, easeOut, function( value ){			my_mc._x = value;		});
		clearInterval( animInterval );
	
	EASING:
		easeLinear
		easeIn
		easeOut
		
	NOTE:
		This can also use Flash's native easing functions
*/
function quikTween( startAt, endAt, seconds, ease, callback, fps ){
	var fps = fps || 30;
	var frames = seconds * fps;
	var mag = endAt - startAt;
	
	var frame = 0;
	var interval = setInterval( function(){
		frame++;
		var value = ease( frame, startAt, mag, frames );
		callback( value );
		if(frame == frames){
			clearInterval( interval );
		}
	}, 33 );
	
	return interval;
}// quikTween()

function easeLinear( thisFrame, startAt, mag, totalFrames ){
	return mag * (thisFrame / totalFrames) + startAt;
}// easeLinear()

function easeIn( thisFrame, startAt, mag, totalFrames ){
	var pow = 3;
	var value = (thisFrame / totalFrames);
	var value = Math.pow(value, pow);
	var output = mag * value + startAt;
	return output;
}// easeIn()

function easeOut( thisFrame, startAt, mag, totalFrames ){
	var pow = 3;
	var value = (thisFrame / totalFrames);
	var value = 1 - Math.pow(1 - value, pow);
	var output = mag * value + startAt;
	return output;
}// easeOut()